// ==========================================================================
//
// = LIBRARY
//     PCIEFPGA
// 
// = FILENAME
//     CPCIEConfigSpace.cpp
// 
// = COPYRIGHT
//     (C) Copyright 2003 Agilent Technologies
//
// ==========================================================================
#include "PCIEConfigSpace.h"
#include "devpcieintdefs.h"
#include "AgtPCIEControl.h"


//***************************************************************************
CPCIEConfigSpace::CPCIEConfigSpace()
{
 myController=new CAgtPCIEControl(); // returns only pointer if instance exists
}

//***************************************************************************
CPCIEConfigSpace::~CPCIEConfigSpace()
{
  delete myController;
  myController = NULL; 
}

//***************************************************************************
UInt32
CPCIEConfigSpace::ConfigSpaceDirectRead(const AgtPortHandleT& portHandle, UInt32 offset)
{
  UInt32 val;
  myController->ConfRegDirectRead(portHandle,offset,val);
  return val;
}


//***************************************************************************
void
CPCIEConfigSpace::ConfigSpaceDirectWrite(const AgtPortHandleT& portHandle, UInt32 offset, UInt32 val)
{
  myController->ConfRegDirectWrite(portHandle,offset,val);
}


